
clc
clear
format short
format compact


p_o = 0.15;        % -----------  Stuck-open defect rate ----------------
p_c = 0;         % ----------- Stuck-closed defect rate --------------

SampleSize = 50;
   matrix_file = 'function_matrix.xlsx';

for k = 1:11
    FM =  xlsread(matrix_file, k);
    [row , column] = size(FM);
    
    if row < column
        FM = FM';
        [row, column] =  size(FM);
    end   
    
    
    row_n = ceil(row*1.5);
    column_m = ceil(column.*1.5);
    
    for t = 1:SampleSize      
        
        CM = randsrc(row_n, column_m, [ 1 0 -1 ; p_c 1- (p_o + p_c) p_o]);        
    
        fileName = sprintf('CM_%dx%d_%0.2f_%d.mat', row, column,p_o, t);
        save(fileName, 'CM')
        
        
    end
    
    
    
end

display('Fin')
